Public Class Designer
    Inherits Object

    ''' <summary>
    ''' Steuerelemente fr Designer
    ''' </summary>
    ''' <remarks></remarks>
    Public Structure Controls
        Dim Button As Boolean
        Dim CheckBox As Boolean
        Dim CheckedListBox As Boolean
        Dim ComboBox As Boolean
        Dim DateTimePicker As Boolean
        Dim Label As Boolean
        Dim LinkLabel As Boolean
        Dim ListBox As Boolean
        Dim ListView As Boolean
        Dim MaskedTextBox As Boolean
        Dim MonthCalendar As Boolean
        Dim NotifyIcon As Boolean
        Dim PictureBox As Boolean
        Dim ProgressBar As Boolean
        Dim RadioButton As Boolean
        Dim RichTextBox As Boolean
        Dim TextBox As Boolean
        Dim ToolTip As Boolean
        Dim TreeView As Boolean
        Dim WebBrowser As Boolean
        Dim GroupBox As Boolean
        Dim Panel As Boolean
        Dim TabControl As Boolean
        Dim TableLayoutPanel As Boolean
        Dim ContextMenuStrip As Boolean
        Dim DataGridView As Boolean
        Dim ImageList As Boolean
        Dim Timer As Boolean
        Dim ColorDialog As Boolean
        Dim FolderBrowserDialog As Boolean
        Dim FontDialog As Boolean
        Dim OpenFileDialog As Boolean
        Dim SaveFileDialog As Boolean
    End Structure

    ''' <summary>
    ''' Code-Seite anzeigen
    ''' </summary>
    ''' <value>
    ''' True / False
    ''' </value>
    ''' <remarks></remarks>
    Public Property ShowCode() As Boolean
        Get
            Return mShowCode
        End Get
        Set(ByVal value As Boolean)
            mShowCode = value
            'Wert prfen
            If value = False Then
                'Code - Seite entfernen
                mForm.mTabControl.TabPages.RemoveAt(1)
            End If
        End Set
    End Property

    ''' <summary>
    ''' ffnen-Button anzeigen
    ''' </summary>
    ''' <value>
    ''' True / False
    ''' </value>
    ''' <remarks></remarks>
    Public Property ShowOpenButton() As Boolean
        Get
            'Open - Button auslesen
            mShowOpenButton = mForm.mTSopen.Visible
            'Separator einblenden
            If mShowOpenButton = True Then
                mForm.mTSSeparator1.Visible = True
            End If
            Return mShowOpenButton
        End Get
        Set(ByVal value As Boolean)
            mShowOpenButton = value
            'Open - Button setzen
            mForm.mTSopen.Visible = value
            'Prfen ob Separator ausgeblendet werden muss
            If (mShowOpenButton = False) And (mShowNewButton = False) And (mShowSaveButton = False) And (mShowDeleteButton = False) Then
                mForm.mTSSeparator1.Visible = False
            End If
        End Set
    End Property

    ''' <summary>
    ''' Neu-Button anzeigen
    ''' </summary>
    ''' <value>
    ''' True / False
    ''' </value>
    ''' <remarks></remarks>
    Public Property ShowNewButton() As Boolean
        Get
            'Neu - Button auslesen
            mShowNewButton = mForm.mTSNew.Visible
            'Separator einblenden
            If mShowNewButton = True Then
                mForm.mTSSeparator1.Visible = True
            End If
            Return mShowNewButton
        End Get
        Set(ByVal value As Boolean)
            mShowNewButton = value
            'Neu - Button setzen
            mForm.mTSNew.Visible = value
            'Prfen ob Separator ausgeblendet werden muss
            If (mShowOpenButton = False) And (mShowNewButton = False) And (mShowSaveButton = False) And (mShowDeleteButton = False) Then
                mForm.mTSSeparator1.Visible = False
            End If
        End Set
    End Property

    ''' <summary>
    ''' Speichern-Button anzeigen
    ''' </summary>
    ''' <value>
    ''' True / False
    ''' </value>
    ''' <remarks></remarks>
    Public Property ShowSaveButton() As Boolean
        Get
            'Speichern - Button auslesen
            mShowSaveButton = mForm.mTSSave.Visible
            'Separator einblenden
            If mShowSaveButton = True Then
                mForm.mTSSeparator1.Visible = True
            End If
            Return mShowSaveButton
        End Get
        Set(ByVal value As Boolean)
            mShowSaveButton = value
            'Speichern - Button setzen
            mForm.mTSSave.Visible = value
            'Prfen ob Separator ausgeblendet werden muss
            If (mShowOpenButton = False) And (mShowNewButton = False) And (mShowSaveButton = False) And (mShowDeleteButton = False) Then
                mForm.mTSSeparator1.Visible = False
            End If
        End Set
    End Property

    ''' <summary>
    ''' Lschen-Button anzeigen
    ''' </summary>
    ''' <value>
    ''' True / False
    ''' </value>
    ''' <remarks></remarks>
    Public Property ShowDeleteButton() As Boolean
        Get
            'Lschen - Button auslesen
            mShowDeleteButton = mForm.mTSDelete.Visible
            'Separator einblenden
            If mShowDeleteButton = True Then
                mForm.mTSSeparator1.Visible = True
            End If
            Return mShowDeleteButton
        End Get
        Set(ByVal value As Boolean)
            mShowDeleteButton = value
            'Lschen - Button setzen
            mForm.mTSDelete.Visible = value
            'Prfen ob Separator ausgeblendet werden muss
            If (mShowOpenButton = False) And (mShowNewButton = False) And (mShowSaveButton = False) And (mShowDeleteButton = False) Then
                mForm.mTSSeparator1.Visible = False
            End If
        End Set
    End Property

    ''' <summary>
    ''' Container Beschriftung
    ''' </summary>
    ''' <value>
    ''' Anzeigetext
    ''' </value>
    ''' <remarks></remarks>
    Public Property ContainerCaption() As String
        Get
            'Container-Beschriftung
            mContainerCaption = mForm.ContainerCaption
            Return mContainerCaption
        End Get
        Set(ByVal value As String)
            mContainerCaption = value
            'Container-Beschriftung
            mForm.ContainerCaption = value
        End Set
    End Property

    ''' <summary>
    ''' Neues Design speichern
    ''' </summary>
    ''' <value>
    ''' True / False
    ''' </value>
    ''' <remarks></remarks>
    Public Property SaveNewDesign() As Boolean
        Get
            Return mSaveNewDesign
        End Get
        Set(ByVal value As Boolean)
            mSaveNewDesign = value
        End Set
    End Property

    ''' <summary>
    ''' ID des aktuellen Designs
    ''' </summary>
    ''' <value>
    ''' ID-Nummer
    ''' </value>
    ''' <remarks></remarks>
    Public Property CurrentDesignID() As Object
        Get
            Return mCurrentDesignID
        End Get
        Set(ByVal value As Object)
            mCurrentDesignID = value
        End Set
    End Property

    ''' <summary>
    ''' Nur diese Kategorien werden angezeigt
    ''' </summary>
    Public Property PropertyGridBrowsableCategories() As System.ComponentModel.AttributeCollection
        Get
            Return m_BrowsableAttributes
        End Get
        Set(ByVal value As System.ComponentModel.AttributeCollection)
            If m_BrowsableAttributes IsNot value Then
                m_HiddenAttributes = Nothing
                m_BrowsableAttributes = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Kategorien werden nicht angezeigt
    ''' </summary>
    Public Property PropertyGridHiddenCategories() As System.ComponentModel.AttributeCollection
        Get
            Return m_HiddenAttributes
        End Get
        Set(ByVal value As System.ComponentModel.AttributeCollection)
            If value IsNot m_HiddenAttributes Then
                m_HiddenAttributes = value
                m_BrowsableAttributes = Nothing
            End If
        End Set
    End Property
    ''' <summary>
    ''' Eigenschaften werden angezeigt
    ''' </summary>
    Public Property PropertyGridBrowsableProperties() As String()
        Get
            Return m_BrowsableProperties
        End Get
        Set(ByVal value As String())
            If value IsNot m_BrowsableProperties Then
                m_BrowsableProperties = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Eigenschaften werden nicht angezeigt
    ''' </summary>
    Public Property PropertyGridHiddenProperties() As String()
        Get
            Return m_HiddenProperties
        End Get
        Set(ByVal value As String())
            If value IsNot m_HiddenProperties Then
                m_HiddenProperties = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Anzeige der Eigenschaften aktualisieren
    ''' </summary>
    Public Property ContainerSelectable() As Boolean
        Get
            Return m_ContainerSelectable
        End Get
        Set(ByVal value As Boolean)
            m_ContainerSelectable = value
        End Set
    End Property

    ''' <summary>
    ''' Komponenten des aktuellen Entwurfs
    ''' </summary>
    ''' <remarks>
    ''' alle Objekte des aktuellen Designs
    ''' </remarks>
    Public ReadOnly Property DesignComponents() As Collection
        Get
            'Laufvariable
            Dim i As Integer
            'Komponenten
            Dim mCom As Object
            'Steuerelement
            Dim mControl As New Object
            'Sammlung Steuerelemente
            Dim mColl As New Collection

            mControl = Nothing
            'Container-Komponenten
            For i = 0 To mForm.host.Container.Components.Count - 1
                mCom = mForm.host.Container.Components(i)
                If mCom IsNot Nothing Then
                    Select Case mCom.GetType.Name.ToUpper
                        Case "BUTTON"
                            mControl = CType(mCom, Button)
                        Case "CHECKBOX"
                            mControl = CType(mCom, CheckBox)
                        Case "CHECKEDLISTBOX"
                            mControl = CType(mCom, CheckedListBox)
                        Case "COMBOBOX"
                            mControl = CType(mCom, ComboBox)
                        Case "DATETIMEPICKER"
                            mControl = CType(mCom, DateTimePicker)
                        Case "LABEL"
                            mControl = CType(mCom, Label)
                        Case "LINKLABEL"
                            mControl = CType(mCom, LinkLabel)
                        Case "LISTBOX"
                            mControl = CType(mCom, ListBox)
                        Case "LISTVIEW"
                            mControl = CType(mCom, ListView)
                        Case "MASKEDTEXTBOX"
                            mControl = CType(mCom, MaskedTextBox)
                        Case "MONTHCALENDAR"
                            mControl = CType(mCom, MonthCalendar)
                        Case "NOTIFYICON"
                            mControl = CType(mCom, NotifyIcon)
                        Case "PICTUREBOX"
                            mControl = CType(mCom, PictureBox)
                        Case "PROGRESSBAR"
                            mControl = CType(mCom, ProgressBar)
                        Case "RADIOBUTTON"
                            mControl = CType(mCom, RadioButton)
                        Case "RICHTEXTBOX"
                            mControl = CType(mCom, RichTextBox)
                        Case "TEXTBOX"
                            mControl = CType(mCom, TextBox)
                        Case "TOOLTIP"
                            mControl = CType(mCom, ToolTip)
                        Case "TREEVIEW"
                            mControl = CType(mCom, TreeView)
                        Case "WEBBROWSER"
                            mControl = CType(mCom, WebBrowser)
                        Case "GROUPBOX"
                            mControl = CType(mCom, GroupBox)
                        Case "PANEL"
                            mControl = CType(mCom, Panel)
                        Case "TABCONTROL"
                            mControl = CType(mCom, TabControl)
                        Case "TABLELAYOUTPANEL"
                            mControl = CType(mCom, TableLayoutPanel)
                        Case "CONTEXTMENUSTRIP"
                            mControl = CType(mCom, ContextMenuStrip)
                        Case "DATAGRIDVIEW"
                            mControl = CType(mCom, DataGridView)
                        Case "IMAGELIST"
                            mControl = CType(mCom, ImageList)
                        Case "TIMER"
                            mControl = CType(mCom, Timer)
                        Case "COLORDIALOG"
                            mControl = CType(mCom, ColorDialog)
                        Case "FOLDERBROWSERDIALOG"
                            mControl = CType(mCom, FolderBrowserDialog)
                        Case "FONTDIALOG"
                            mControl = CType(mCom, FontDialog)
                        Case "OPENFILEDIALOG"
                            mControl = CType(mCom, OpenFileDialog)
                        Case "SAVEFILEDIALOG"
                            mControl = CType(mCom, SaveFileDialog)
                    End Select
                    If mControl IsNot Nothing Then
                        'Sammlung hinzufgen
                        mColl.Add(mControl, CStr(mColl.Count - 1))
                    End If
                End If
            Next
            Return mColl
        End Get
    End Property
    ''' <summary>
    ''' Komponenten des aktuellen Entwurfs, welche serialisiert werden knnen
    ''' </summary>
    ''' <remarks>
    ''' alle Objekte (serializable) des aktuellen Designs
    ''' </remarks>
    Public ReadOnly Property SerializeDesignComponents() As Collection
        Get
            'Laufvariable
            Dim i As Integer
            'Komponenten
            Dim mCom As Object
            'Steuerelement
            Dim mControl As New Object
            'Sammlung Steuerelemente
            Dim mColl As New Collection

            mControl = Nothing
            'Container-Komponenten
            For i = 0 To mForm.host.Container.Components.Count - 1
                mCom = mForm.host.Container.Components(i)
                If mCom IsNot Nothing Then
                    Select Case mCom.GetType.Name.ToUpper
                        Case "BUTTON"
                            mControl = CType(mCom, Button)
                        Case "CHECKBOX"
                            mControl = CType(mCom, CheckBox)
                        Case "CHECKEDLISTBOX"
                            mControl = CType(mCom, CheckedListBox)
                        Case "COMBOBOX"
                            mControl = CType(mCom, ComboBox)
                        Case "DATETIMEPICKER"
                            mControl = CType(mCom, DateTimePicker)
                        Case "LABEL"
                            mControl = CType(mCom, Label)
                        Case "LINKLABEL"
                            mControl = CType(mCom, LinkLabel)
                        Case "LISTBOX"
                            mControl = CType(mCom, ListBox)
                        Case "LISTVIEW"
                            mControl = CType(mCom, ListView)
                        Case "MASKEDTEXTBOX"
                            mControl = CType(mCom, MaskedTextBox)
                        Case "MONTHCALENDAR"
                            mControl = CType(mCom, MonthCalendar)
                        Case "NOTIFYICON"
                            mControl = CType(mCom, NotifyIcon)
                        Case "PICTUREBOX"
                            mControl = CType(mCom, PictureBox)
                        Case "PROGRESSBAR"
                            mControl = CType(mCom, ProgressBar)
                        Case "RADIOBUTTON"
                            mControl = CType(mCom, RadioButton)
                        Case "RICHTEXTBOX"
                            mControl = CType(mCom, RichTextBox)
                        Case "TEXTBOX"
                            mControl = CType(mCom, TextBox)
                        Case "TOOLTIP"
                            mControl = CType(mCom, ToolTip)
                        Case "TREEVIEW"
                            mControl = CType(mCom, TreeView)
                        Case "WEBBROWSER"
                            mControl = CType(mCom, WebBrowser)
                        Case "GROUPBOX"
                            mControl = CType(mCom, GroupBox)
                        Case "PANEL"
                            mControl = CType(mCom, Panel)
                        Case "TABCONTROL"
                            mControl = CType(mCom, TabControl)
                        Case "TABLELAYOUTPANEL"
                            mControl = CType(mCom, TableLayoutPanel)
                        Case "CONTEXTMENUSTRIP"
                            mControl = CType(mCom, ContextMenuStrip)
                        Case "DATAGRIDVIEW"
                            mControl = CType(mCom, DataGridView)
                        Case "IMAGELIST"
                            mControl = CType(mCom, ImageList)
                        Case "TIMER"
                            mControl = CType(mCom, Timer)
                        Case "COLORDIALOG"
                            mControl = CType(mCom, ColorDialog)
                        Case "FOLDERBROWSERDIALOG"
                            mControl = CType(mCom, FolderBrowserDialog)
                        Case "FONTDIALOG"
                            mControl = CType(mCom, FontDialog)
                        Case "OPENFILEDIALOG"
                            mControl = CType(mCom, OpenFileDialog)
                        Case "SAVEFILEDIALOG"
                            mControl = CType(mCom, SaveFileDialog)
                    End Select

                    'Steuerelement-Klasse erzeugen
                    Dim mUserControl As New SerializeControl
                    'Typ des Steuerelements setzen
                    mUserControl.Typ = mCom.GetType.Name
                    'prfen ob Steuerelement die Eigenschaft hat und setzen
                    If mCom.GetType().GetProperty("AccessibleDescription") IsNot Nothing Then
                        mUserControl.AccessibleDescription = mControl.AccessibleDescription
                    ElseIf mCom.GetType().GetProperty("AcceptsReturn") IsNot Nothing Then
                        mUserControl.AcceptsReturn = mControl.AcceptsReturn
                    ElseIf mCom.GetType().GetProperty("AcceptsTab") IsNot Nothing Then
                        mUserControl.AcceptsTab = mControl.AcceptsTab
                    ElseIf mCom.GetType().GetProperty("AllowDrop") IsNot Nothing Then
                        mUserControl.AllowDrop = mControl.AllowDrop
                    ElseIf mCom.GetType().GetProperty("Anchor") IsNot Nothing Then
                        mUserControl.Anchor = mControl.Anchor
                    ElseIf mCom.GetType().GetProperty("AutoCheck") IsNot Nothing Then
                        mUserControl.AutoCheck = mControl.AutoCheck
                    ElseIf mCom.GetType().GetProperty("AutoEllipsis") IsNot Nothing Then
                        mUserControl.AutoEllipsis = mControl.AutoEllipsis
                    ElseIf mCom.GetType().GetProperty("AutoScrollOffset") IsNot Nothing Then
                        mUserControl.AutoScrollOffset = mControl.AutoScrollOffset
                    ElseIf mCom.GetType().GetProperty("AutoSize") IsNot Nothing Then
                        mUserControl.AutoSize = mControl.AutoSize
                    ElseIf mCom.GetType().GetProperty("BackColor") IsNot Nothing Then
                        mUserControl.BackColor = mControl.BackColor
                    ElseIf mCom.GetType().GetProperty("BindingContext") IsNot Nothing Then
                        'mUserControl.BindingContext.DataMember =mControl.BindingContext
                        'mUserControl.BindingContext.DataSource =mControl.BindingContext
                        'mUserControl.BindingContext.DisplayMember =mControl.BindingContext
                    ElseIf mCom.GetType().GetProperty("BorderStyle") IsNot Nothing Then
                        mUserControl.BorderStyle = mControl.BorderStyle
                    ElseIf mCom.GetType().GetProperty("Bottom") IsNot Nothing Then
                        mUserControl.Bottom = mControl.Bottom
                    ElseIf mCom.GetType().GetProperty("Bounds") IsNot Nothing Then
                        mUserControl.Bounds = mControl.Bounds
                    ElseIf mCom.GetType().GetProperty("CanFocus") IsNot Nothing Then
                        mUserControl.CanFocus = mControl.CanFocus
                    ElseIf mCom.GetType().GetProperty("CanSelect") IsNot Nothing Then
                        mUserControl.CanSelect = mControl.CanSelect
                    ElseIf mCom.GetType().GetProperty("CanUndo") IsNot Nothing Then
                        mUserControl.CanUndo = mControl.CanUndo
                    ElseIf mCom.GetType().GetProperty("Capture") IsNot Nothing Then
                        mUserControl.Capture = mControl.Capture
                    ElseIf mCom.GetType().GetProperty("CausesValidation") IsNot Nothing Then
                        mUserControl.CausesValidation = mControl.CausesValidation
                    ElseIf mCom.GetType().GetProperty("CharacterCasing") IsNot Nothing Then
                        mUserControl.CharacterCasing = mControl.CharacterCasing
                    ElseIf mCom.GetType().GetProperty("CheckAlign") IsNot Nothing Then
                        mUserControl.CheckAlign = mControl.CheckAlign
                    ElseIf mCom.GetType().GetProperty("Checked") IsNot Nothing Then
                        mUserControl.Checked = mControl.Checked
                    ElseIf mCom.GetType().GetProperty("CheckState") IsNot Nothing Then
                        mUserControl.CheckState = mControl.CheckState
                    ElseIf mCom.GetType().GetProperty("CheckForIllegalCrossThreadCalls") IsNot Nothing Then
                        mUserControl.CheckForIllegalCrossThreadCalls = mControl.CheckForIllegalCrossThreadCalls
                    ElseIf mCom.GetType().GetProperty("ClientRectangle") IsNot Nothing Then
                        mUserControl.ClientRectangle = mControl.ClientRectangle
                    ElseIf mCom.GetType().GetProperty("ClientSize") IsNot Nothing Then
                        mUserControl.ClientSize = mControl.ClientSize
                    ElseIf mCom.GetType().GetProperty("ColumnWidth") IsNot Nothing Then
                        mUserControl.ColumnWidth = mControl.ColumnWidth
                    ElseIf mCom.GetType().GetProperty("CompanyName") IsNot Nothing Then
                        mUserControl.CompanyName = mControl.CompanyName
                    ElseIf mCom.GetType().GetProperty("Created") IsNot Nothing Then
                        mUserControl.Created = mControl.Created
                    ElseIf mCom.GetType().GetProperty("Cursor") IsNot Nothing Then
                        mUserControl.Cursor = mControl.Cursor
                    ElseIf mCom.GetType().GetProperty("DisplayRectangle") IsNot Nothing Then
                        mUserControl.DisplayRectangle = mControl.DisplayRectangle
                    ElseIf mCom.GetType().GetProperty("Dock") IsNot Nothing Then
                        mUserControl.Dock = mControl.Dock
                    ElseIf mCom.GetType().GetProperty("DropDownHeight") IsNot Nothing Then
                        mUserControl.DropDownHeight = mControl.DropDownHeight
                    ElseIf mCom.GetType().GetProperty("DropDownStyle") IsNot Nothing Then
                        mUserControl.DropDownStyle = mControl.DropDownStyle
                    ElseIf mCom.GetType().GetProperty("DropDownWidth") IsNot Nothing Then
                        mUserControl.DropDownWidth = mControl.DropDownWidth
                    ElseIf mCom.GetType().GetProperty("DroppedDown") IsNot Nothing Then
                        mUserControl.DroppedDown = mControl.DroppedDown
                    ElseIf mCom.GetType().GetProperty("Enabled") IsNot Nothing Then
                        mUserControl.Enabled = mControl.Enabled
                    ElseIf mCom.GetType().GetProperty("FlatAppearance") IsNot Nothing Then
                        mUserControl.FlatAppearance = mControl.FlatAppearance
                    ElseIf mCom.GetType().GetProperty("FlatStyle") IsNot Nothing Then
                        mUserControl.FlatStyle = mControl.FlatStyle
                    ElseIf mCom.GetType().GetProperty("Focused") IsNot Nothing Then
                        mUserControl.Focused = mControl.Focused
                    ElseIf mCom.GetType().GetProperty("Font") IsNot Nothing Then
                        mUserControl.Font.Bold = mControl.Font.Bold
                        mUserControl.Font.Italic = mControl.Font.Italic
                        mUserControl.Font.Name = mControl.Font.Name
                        mUserControl.Font.Size = mControl.Font.Size
                        mUserControl.Font.Strikeout = mControl.Font.Strikeout
                        mUserControl.Font.Underline = mControl.Font.Underline
                    ElseIf mCom.GetType().GetProperty("ForeColor") IsNot Nothing Then
                        mUserControl.ForeColor = mControl.ForeColor
                    ElseIf mCom.GetType().GetProperty("Height") IsNot Nothing Then
                        mUserControl.Height = mControl.Height
                    ElseIf mCom.GetType().GetProperty("HideSelection") IsNot Nothing Then
                        mUserControl.HideSelection = mControl.HideSelection
                    ElseIf mCom.GetType().GetProperty("HorizontalScrollbar") IsNot Nothing Then
                        mUserControl.HorizontalScrollbar = mControl.HorizontalScrollbar
                    ElseIf mCom.GetType().GetProperty("ItemHeight") IsNot Nothing Then
                        mUserControl.ItemHeight = mControl.ItemHeight
                    ElseIf mCom.GetType().GetProperty("Items") IsNot Nothing Then
                        mUserControl.Items = mControl.Items
                    ElseIf mCom.GetType().GetProperty("Lines") IsNot Nothing Then
                        mUserControl.Lines = mControl.Lines
                    ElseIf mCom.GetType().GetProperty("Location") IsNot Nothing Then
                        mUserControl.Location = mControl.Location
                    ElseIf mCom.GetType().GetProperty("MaxDropDownItems") IsNot Nothing Then
                        mUserControl.MaxDropDownItems = mControl.MaxDropDownItems
                    ElseIf mCom.GetType().GetProperty("MaximumSize") IsNot Nothing Then
                        mUserControl.MaximumSize = mControl.MaximumSize
                    ElseIf mCom.GetType().GetProperty("MaxLength") IsNot Nothing Then
                        mUserControl.MaxLength = mControl.MaxLength
                    ElseIf mCom.GetType().GetProperty("MinimumSize") IsNot Nothing Then
                        mUserControl.MinimumSize = mControl.MinimumSize
                    ElseIf mCom.GetType().GetProperty("MultiColumn") IsNot Nothing Then
                        mUserControl.MultiColumn = mControl.MultiColumn
                    ElseIf mCom.GetType().GetProperty("Multiline") IsNot Nothing Then
                        mUserControl.Multiline = mControl.Multiline
                    ElseIf mCom.GetType().GetProperty("Name") IsNot Nothing Then
                        mUserControl.Name = mControl.Name
                    ElseIf mCom.GetType().GetProperty("PasswordChar") IsNot Nothing Then
                        mUserControl.PasswordChar = mControl.PasswordChar
                    ElseIf mCom.GetType().GetProperty("PreferredHeight") IsNot Nothing Then
                        mUserControl.PreferredHeight = mControl.PreferredHeight
                    ElseIf mCom.GetType().GetProperty("PreferredSize") IsNot Nothing Then
                        mUserControl.PreferredSize = mControl.PreferredSize
                    ElseIf mCom.GetType().GetProperty("PreferredWidth") IsNot Nothing Then
                        mUserControl.PreferredWidth = mControl.PreferredWidth
                    ElseIf mCom.GetType().GetProperty("ReadOnly") IsNot Nothing Then
                        mUserControl.ReadsOnly = mControl.ReadOnly
                    ElseIf mCom.GetType().GetProperty("SelectionMode") IsNot Nothing Then
                        mUserControl.SelectionMode = mControl.SelectionMode
                    ElseIf mCom.GetType().GetProperty("ScrollAlwaysVisible") IsNot Nothing Then
                        mUserControl.ScrollAlwaysVisible = mControl.ScrollAlwaysVisible
                    ElseIf mCom.GetType().GetProperty("ScrollBars") IsNot Nothing Then
                        mUserControl.ScrollBars = mControl.ScrollBars
                    ElseIf mCom.GetType().GetProperty("Size") IsNot Nothing Then
                        mUserControl.Size = mControl.Size
                    ElseIf mCom.GetType().GetProperty("Sorted") IsNot Nothing Then
                        mUserControl.Sorted = mControl.Sorted
                    ElseIf mCom.GetType().GetProperty("TabIndex") IsNot Nothing Then
                        mUserControl.TabIndex = mControl.TabIndex
                    ElseIf mCom.GetType().GetProperty("TabStop") IsNot Nothing Then
                        mUserControl.TabStop = mControl.TabStop
                    ElseIf mCom.GetType().GetProperty("Text") IsNot Nothing Then
                        mUserControl.Text = mControl.Text
                    ElseIf mCom.GetType().GetProperty("TextAlign") IsNot Nothing Then
                        mUserControl.TextAlign = mControl.TextAlign
                    ElseIf mCom.GetType().GetProperty("TextLength") IsNot Nothing Then
                        mUserControl.TextLength = mControl.TextLength
                    ElseIf mCom.GetType().GetProperty("ThreeState") IsNot Nothing Then
                        mUserControl.ThreeState = mControl.ThreeState
                    ElseIf mCom.GetType().GetProperty("TopIndex") IsNot Nothing Then
                        mUserControl.TopIndex = mControl.TopIndex
                    ElseIf mCom.GetType().GetProperty("UseVisualStyleBackColor") IsNot Nothing Then
                        mUserControl.UseVisualStyleBackColor = mControl.UseVisualStyleBackColor
                    ElseIf mCom.GetType().GetProperty("ValueMember") IsNot Nothing Then
                        mUserControl.ValueMember = mControl.ValueMember
                    ElseIf mCom.GetType().GetProperty("Visible") IsNot Nothing Then
                        mUserControl.Visible = mControl.Visible
                    ElseIf mCom.GetType().GetProperty("Width") IsNot Nothing Then
                        mUserControl.Width = mControl.Width
                    End If
                    'Control Sammlung hinzufgen
                    mColl.Add(mUserControl, CStr(mColl.Count - 1))
                End If
            Next
            Return mColl
        End Get
    End Property

    ''' <summary>
    ''' Neues Formular erzeugen
    ''' </summary>
    ''' <param name="DockPanel">
    ''' Container fr das Formular
    ''' </param>
    ''' <param name="DockState">
    ''' Anzeigestatus des Formular
    ''' </param>
    ''' <param name="mControls">
    ''' Steuerelemente, welche in der Toolbox verfgbar sind
    ''' </param>
    ''' <remarks></remarks>
    <CLSCompliant(False)> Public Sub New(ByVal DockPanel As WeifenLuo.WinFormsUI.DockPanel, ByVal DockState As WeifenLuo.WinFormsUI.DockState, ByVal mControls As SBSFormDesigner.Designer.Controls)
        MyBase.New()

        'Formulareigenschaften
        mDockPanel = DockPanel
        mDockState = DockState

        'Steuerelemente setzen
        With mSteuerelemente
            .Button = mControls.Button
            .CheckBox = mControls.CheckBox
            .CheckedListBox = mControls.CheckedListBox
            .ComboBox = mControls.ComboBox
            .DateTimePicker = mControls.DateTimePicker
            .Label = mControls.Label
            .LinkLabel = mControls.LinkLabel
            .ListBox = mControls.ListBox
            .ListView = mControls.ListView
            .MaskedTextBox = mControls.MaskedTextBox
            .MonthCalendar = mControls.MonthCalendar
            .NotifyIcon = mControls.NotifyIcon
            .PictureBox = mControls.PictureBox
            .ProgressBar = mControls.ProgressBar
            .RadioButton = mControls.RadioButton
            .RichTextBox = mControls.RichTextBox
            .TextBox = mControls.TextBox
            .ToolTip = mControls.ToolTip
            .TreeView = mControls.TreeView
            .WebBrowser = mControls.WebBrowser
            .GroupBox = mControls.GroupBox
            .Panel = mControls.Panel
            .TabControl = mControls.TabControl
            .TableLayoutPanel = mControls.TableLayoutPanel
            .ContextMenuStrip = mControls.ContextMenuStrip
            .DataGridView = mControls.DataGridView
            .ImageList = mControls.ImageList
            .Timer = mControls.Timer
            .ColorDialog = mControls.ColorDialog
            .FolderBrowserDialog = mControls.FolderBrowserDialog
            .FontDialog = mControls.FontDialog
            .OpenFileDialog = mControls.OpenFileDialog
            .SaveFileDialog = mControls.SaveFileDialog
        End With
        'initialiseren
        mSaveNewDesign = False
        mCurrentDesignID = Nothing

        'Designer initialisieren
        mForm = New SBSFormDesigner.frmMain

        'Ereignisse den Buttons zuordnen
        AddHandler mForm.mTSopen.Click, AddressOf DesignOpen
        AddHandler mForm.mTSNew.Click, AddressOf DesignNew
        AddHandler mForm.mTSSave.Click, AddressOf DesignSave
        AddHandler mForm.mTSDelete.Click, AddressOf DesignDelete

    End Sub


    ''' <summary>
    ''' Formular anzeigen
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Show()
        'initialisieren
        mSaveNewDesign = True
        'neues Projekt zeigen
        mForm.Show(mDockPanel, mDockState)
        'Ereignis auslsen z.B. zum ermitteln neuer ID fr neues Design
        RaiseEvent ProcedureNewDesign()
    End Sub


    ''' <summary>
    ''' Objekt beenden - Speicher freigeben
    ''' </summary>
    ''' <remarks></remarks>
    Protected Overrides Sub Finalize()
        MyBase.Finalize()
    End Sub

    '==============================================================================
    'EVENTS Definitionen
    '==============================================================================

    ''' <summary>
    ''' Ereignis fr Design ffnen
    ''' </summary>
    ''' <remarks></remarks>
    Public Event ProcedureOpenDesign()

    ''' <summary>
    ''' Ereignis fr Design Neu
    ''' </summary>
    ''' <remarks></remarks>
    Public Event ProcedureNewDesign()

    ''' <summary>
    ''' Ereignis fr Design Speichern
    ''' </summary>
    ''' <remarks></remarks>
    Public Event ProcedureSaveDesign()

    ''' <summary>
    ''' Ereignis fr Design Lschen
    ''' </summary>
    ''' <remarks></remarks>
    Public Event ProcedureDeleteDesign()


    '==============================================================================
    'FRIEND Definitionen
    '==============================================================================



    '==============================================================================
    'PRIVATE Definitionen
    '==============================================================================
    'Formular
    Dim mForm As SBSFormDesigner.frmMain
    'Formularstatus
    Dim mDockPanel As WeifenLuo.WinFormsUI.DockPanel
    Dim mDockState As WeifenLuo.WinFormsUI.DockState
    'Code anzeigen
    Dim mShowCode As Boolean
    'Open - Button
    Dim mShowOpenButton As Boolean
    'Neu - Button
    Dim mShowNewButton As Boolean
    'Speichern - Button
    Dim mShowSaveButton As Boolean
    'Lschen - Button
    Dim mShowDeleteButton As Boolean
    'Container-Beschriftung
    Dim mContainerCaption As String
    'aktueller Entwurf
    Dim mCurrentDesign As Object
    'ID des aktuellen Entwurfs
    Dim mCurrentDesignID As Object
    'neuen Entwurf 
    Dim mSaveNewDesign As Boolean


    'Ereignis Design ffnen auslsen
    Private Sub DesignOpen(ByVal sender As Object, ByVal e As System.EventArgs)
        RaiseEvent ProcedureOpenDesign()
    End Sub

    'Ereignis Design Neu auslsen
    Private Sub DesignNew(ByVal sender As Object, ByVal e As System.EventArgs)
        mSaveNewDesign = True
        RaiseEvent ProcedureNewDesign()
    End Sub

    'Ereignis Design Speichern auslsen
    Private Sub DesignSave(ByVal sender As Object, ByVal e As System.EventArgs)
        RaiseEvent ProcedureSaveDesign()
        mSaveNewDesign = False
    End Sub

    'Ereignis Design Lschen auslsen
    Private Sub DesignDelete(ByVal sender As Object, ByVal e As System.EventArgs)
        RaiseEvent ProcedureDeleteDesign()
    End Sub
End Class

