Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Drawing
Imports System.Data
Imports System.Text
Imports System.Windows.Forms


''' <summary>
''' This class is a wrapper. It contains the object the propertyGrid has to display.
''' </summary>
Friend Class ObjectWrapper

    Implements ICustomTypeDescriptor

    ''' <summary>
    ''' Contain a reference to the selected objet that will linked to the parent PropertyGrid.
    ''' </summary>
    Private m_SelectedObjects() As Object = Nothing

    ''' <summary>
    ''' Contain a reference to the collection of properties to show in the parent PropertyGrid.
    ''' </summary>
    ''' <remarks>
    ''' By default, m_PropertyDescriptors contain all the properties of the object.
    ''' </remarks>
    Private m_PropertyDescriptors As New List(Of PropertyDescriptor)()

    ''' <summary>
    ''' Simple constructor.
    ''' </summary>
    ''' <param name="obj">
    ''' A reference to the selected object that will linked to the parent PropertyGrid.
    ''' </param>
    Friend Sub New(ByVal obj() As Object)
        m_SelectedObjects = obj
    End Sub

    ''' <summary>
    ''' Get or set a reference to the selected objet that will linked to the parent PropertyGrid.
    ''' </summary>
    Public Property SelectedObjects() As Object()
        Get
            Return m_SelectedObjects
        End Get
        Set(ByVal value() As Object)
            If m_SelectedObjects IsNot value Then
                value.CopyTo(m_SelectedObjects, 0)
            End If
        End Set
    End Property

    ''' <summary>
    ''' Get or set a reference to the collection of properties to show in the parent PropertyGrid.
    ''' </summary>
    Public Property PropertyDescriptors() As List(Of PropertyDescriptor)
        Get
            Return m_PropertyDescriptors
        End Get
        Set(ByVal value As List(Of PropertyDescriptor))
            m_PropertyDescriptors = value
        End Set
    End Property

#Region "ICustomTypeDescriptor Members"

    ''' <summary>
    ''' GetAttributes.
    ''' </summary>
    ''' <returns>
    ''' AttributeCollection
    ''' </returns>
    Public Function GetAttributes() As System.ComponentModel.AttributeCollection Implements System.ComponentModel.ICustomTypeDescriptor.GetAttributes
        Return TypeDescriptor.GetAttributes(m_SelectedObjects(0), True)
    End Function

    ''' <summary>
    ''' Get Class Name.
    ''' </summary>
    ''' <returns>
    ''' String
    ''' </returns>
    Public Function GetClassName() As String Implements System.ComponentModel.ICustomTypeDescriptor.GetClassName
        Return TypeDescriptor.GetClassName(m_SelectedObjects(0), True)
    End Function

    ''' <summary>
    ''' GetComponentName.
    ''' </summary>
    ''' <returns>
    ''' String
    ''' </returns>
    Public Function GetComponentName() As String Implements System.ComponentModel.ICustomTypeDescriptor.GetComponentName
        Return TypeDescriptor.GetComponentName(m_SelectedObjects(0), True)
    End Function

    ''' <summary>
    ''' GetConverter.
    ''' </summary>
    ''' <returns>
    ''' TypeConverter
    ''' </returns>
    Public Function GetConverter() As System.ComponentModel.TypeConverter Implements System.ComponentModel.ICustomTypeDescriptor.GetConverter
        Return TypeDescriptor.GetConverter(m_SelectedObjects(0), True)
    End Function

    ''' <summary>
    ''' GetDefaultEvent.
    ''' </summary>
    ''' <returns>
    ''' EventDescriptor
    ''' </returns>
    Public Function GetDefaultEvent() As System.ComponentModel.EventDescriptor Implements System.ComponentModel.ICustomTypeDescriptor.GetDefaultEvent
        Return TypeDescriptor.GetDefaultEvent(m_SelectedObjects(0), True)
    End Function

    ''' <summary>
    ''' GetDefaultProperty.
    ''' </summary>
    ''' <returns>
    ''' PropertyDescriptor
    ''' </returns>
    Public Function GetDefaultProperty() As System.ComponentModel.PropertyDescriptor Implements System.ComponentModel.ICustomTypeDescriptor.GetDefaultProperty
        Return TypeDescriptor.GetDefaultProperty(m_SelectedObjects(0), True)
    End Function

    ''' <summary>
    ''' GetEditor.
    ''' </summary>
    ''' <param name="editorBaseType">
    ''' editorBaseType
    ''' </param>
    ''' <returns>
    ''' object
    ''' </returns>
    Public Function GetEditor(ByVal editorBaseType As System.Type) As Object Implements System.ComponentModel.ICustomTypeDescriptor.GetEditor
        Return TypeDescriptor.GetEditor(Me, editorBaseType, True)
    End Function

    Public Function GetEvents() As System.ComponentModel.EventDescriptorCollection Implements System.ComponentModel.ICustomTypeDescriptor.GetEvents
        Return TypeDescriptor.GetEvents(m_SelectedObjects(0), True)
    End Function

    Public Function GetEvents(ByVal attributes() As System.Attribute) As System.ComponentModel.EventDescriptorCollection Implements System.ComponentModel.ICustomTypeDescriptor.GetEvents
        Return TypeDescriptor.GetEvents(m_SelectedObjects(0), attributes, True)
    End Function

    Public Function GetProperties() As System.ComponentModel.PropertyDescriptorCollection Implements System.ComponentModel.ICustomTypeDescriptor.GetProperties
        Return New PropertyDescriptorCollection(m_PropertyDescriptors.ToArray(), True)
    End Function

    Public Function GetProperties(ByVal attributes() As System.Attribute) As System.ComponentModel.PropertyDescriptorCollection Implements System.ComponentModel.ICustomTypeDescriptor.GetProperties
        Return GetProperties()
    End Function

    Public Function GetPropertyOwner(ByVal pd As System.ComponentModel.PropertyDescriptor) As Object Implements System.ComponentModel.ICustomTypeDescriptor.GetPropertyOwner
        Return m_SelectedObjects(0)
    End Function

#End Region

End Class


''' <summary>
''' Stellt Objekte mit gefilterten Eigenschaften bereit
''' </summary>
Friend Class FilteredProperty
    ''' <summary>
    ''' Contain a reference to the collection of properties to show in the parent PropertyGrid.
    ''' </summary>
    ''' <remarks>
    ''' By default, m_PropertyDescriptors contain all the properties of the object. 
    ''' </remarks>
    Private m_PropertyDescriptors As New List(Of PropertyDescriptor)()

    ''' <summary>
    ''' Contain a reference to the wrapper that contains the object to be displayed into the PropertyGrid.
    ''' </summary>
    Private m_Wrapper As ObjectWrapper = Nothing


    ''' <summary>
    ''' Gibt die Objekte mit den Einstellungen der Anzeige der eigenschaften zurck
    ''' </summary>
    Public ReadOnly Property Wrapper() As ObjectWrapper
        Get
            Return m_Wrapper
        End Get
    End Property

    ''' <summary>
    ''' Overwrite the PropertyGrid.SelectedObject property.
    ''' </summary>
    ''' <remarks>
    ''' The object passed to the base PropertyGrid is the wrapper.
    ''' </remarks>
    Public Property SelectedObjects() As Object()
        Get
            Return IIf(m_Wrapper IsNot Nothing, m_Wrapper.SelectedObjects, Nothing)
        End Get
        Set(ByVal value() As Object)
            ' Set the new object to the wrapper and create one if necessary.
            If m_Wrapper Is Nothing Then
                m_Wrapper = New ObjectWrapper(value)
                RefreshProperties()
            ElseIf m_Wrapper.SelectedObjects IsNot value Then
                'Dim needrefresh As Boolean = value.[GetType]() IsNot m_Wrapper.SelectedObjects.[GetType]()
                m_Wrapper.SelectedObjects = value
                'If needrefresh Then
                RefreshProperties()
                'End If
            End If
            ' Set the list of properties to the wrapper.
            m_Wrapper.PropertyDescriptors = m_PropertyDescriptors
            ' Link the wrapper to the parent PropertyGrid.
            'MyBase.SelectedObject = m_Wrapper
        End Set
    End Property

    ''' <summary>
    ''' Called when the browsable properties have changed.
    ''' </summary>
    Private Sub OnBrowsablePropertiesChanged()
        If m_Wrapper Is Nothing Then
            Exit Sub
        End If
    End Sub

    ''' <summary>
    ''' Build the list of the properties to be displayed in the PropertyGrid, following the filters defined the Browsable and Hidden properties.
    ''' </summary>
    Public Sub RefreshProperties()
        If m_Wrapper Is Nothing Then
            Exit Sub
        End If
        ' Clear the list of properties to be displayed.
        m_PropertyDescriptors.Clear()
        ' Check whether the list is filtered 
        If m_BrowsableAttributes IsNot Nothing AndAlso m_BrowsableAttributes.Count > 0 Then
            ' Add to the list the attributes that need to be displayed.
            For Each attribute As Attribute In m_BrowsableAttributes
                ShowAttribute(attribute)
            Next
        Else
            ' Fill the collection with all the properties.
            Dim originalpropertydescriptors As PropertyDescriptorCollection = TypeDescriptor.GetProperties(m_Wrapper.SelectedObjects(0))
            For Each propertydescriptor As PropertyDescriptor In originalpropertydescriptors
                m_PropertyDescriptors.Add(propertydescriptor)
            Next
            ' Remove from the list the attributes that mustn't be displayed.
            If m_HiddenAttributes IsNot Nothing Then
                For Each attribute As Attribute In m_HiddenAttributes
                    HideAttribute(attribute)
                Next
            End If
        End If
        ' Get all the properties of the SelectedObject
        Dim allproperties As PropertyDescriptorCollection = TypeDescriptor.GetProperties(m_Wrapper.SelectedObjects(0))
        ' Hide if necessary, some properties
        If m_HiddenProperties IsNot Nothing AndAlso m_HiddenProperties.Length > 0 Then
            ' Remove from the list the properties that mustn't be displayed.
            For Each propertyname As String In m_HiddenProperties
                Try
                    Dim [property] As PropertyDescriptor = allproperties(propertyname)
                    ' Remove from the list the property
                    HideProperty([property])
                Catch ex As Exception
                    Throw New ArgumentException(ex.Message)
                End Try
            Next
        End If
        ' Display if necessary, some properties
        If m_BrowsableProperties IsNot Nothing AndAlso m_BrowsableProperties.Length > 0 Then
            For Each propertyname As String In m_BrowsableProperties
                Try
                    ShowProperty(allproperties(propertyname))
                Catch knfe As Exception
                    Throw New ArgumentException("Property not found", propertyname)
                End Try
            Next
        End If
    End Sub
    ''' <summary>
    ''' Allows to hide a set of properties to the parent PropertyGrid.
    ''' </summary>
    ''' <param name="attribute">
    ''' A set of attributes that filter the original collection of properties.
    ''' </param>
    ''' <remarks>
    ''' For better performance, include the BrowsableAttribute with true value.
    ''' </remarks>
    Private Sub HideAttribute(ByVal attribute As Attribute)
        Dim filteredoriginalpropertydescriptors As PropertyDescriptorCollection = TypeDescriptor.GetProperties(m_Wrapper.SelectedObjects, New Attribute() {attribute})
        If filteredoriginalpropertydescriptors Is Nothing OrElse filteredoriginalpropertydescriptors.Count = 0 Then
            Throw New ArgumentException("Attribute not found", attribute.ToString())
        End If
        For Each propertydescriptor As PropertyDescriptor In filteredoriginalpropertydescriptors
            HideProperty(propertydescriptor)
        Next
    End Sub
    ''' <summary>
    ''' Add all the properties that match an attribute to the list of properties to be displayed in the PropertyGrid.
    ''' </summary>
    ''' <param name="attribute">
    ''' The attribute to be added.
    ''' </param>
    Private Sub ShowAttribute(ByVal attribute As Attribute)
        Dim filteredoriginalpropertydescriptors As PropertyDescriptorCollection = TypeDescriptor.GetProperties(m_Wrapper.SelectedObjects, New Attribute() {attribute})
        If filteredoriginalpropertydescriptors Is Nothing OrElse filteredoriginalpropertydescriptors.Count = 0 Then
            Throw New ArgumentException("Attribut nicht vorhanden", attribute.ToString())
        End If
        For Each propertydescriptor As PropertyDescriptor In filteredoriginalpropertydescriptors
            ShowProperty(propertydescriptor)
        Next
    End Sub
    ''' <summary>
    ''' Add a property to the list of properties to be displayed in the PropertyGrid.
    ''' </summary>
    ''' <param name="property">
    ''' The property to be added.
    ''' </param>
    Private Sub ShowProperty(ByVal [property] As PropertyDescriptor)
        If Not m_PropertyDescriptors.Contains([property]) Then
            m_PropertyDescriptors.Add([property])
        End If
    End Sub
    ''' <summary>
    ''' Allows to hide a property to the parent PropertyGrid.
    ''' </summary>
    ''' <param name="property">
    ''' The name of the property to be hidden.
    ''' </param>
    Private Sub HideProperty(ByVal [property] As PropertyDescriptor)
        If m_PropertyDescriptors.Contains([property]) Then
            m_PropertyDescriptors.Remove([property])
        End If
    End Sub

End Class