'==============================================================================
' Basiert auf der Arbeit von Tim Dawson, www.divil.co.uk
'==============================================================================
Imports System
Imports System.Drawing
Imports System.Windows.Forms
Imports System.Windows.Forms.Design
Imports System.Collections

Friend Class UIService
    Implements IUIService

    Private _mainForm As frmMain = Nothing
    Private _styles As Hashtable = Nothing

    <CLSCompliant(False)> Public Sub New(ByVal mainForm As frmMain)
        _mainForm = mainForm

        _styles = New Hashtable()
        _styles.Add("DialogFont", New Font("Tahoma", 8.25F, FontStyle.Regular))
        _styles.Add("HighlightColor", Color.FromArgb(255, 251, 233))
    End Sub

    Public Function CanShowComponentEditor(ByVal component As Object) As Boolean Implements IUIService.CanShowComponentEditor
        Return False
    End Function

    Public Function GetDialogOwnerWindow() As System.Windows.Forms.IWin32Window Implements IUIService.GetDialogOwnerWindow
        Return _mainForm
    End Function

    Public Sub SetUIDirty() Implements IUIService.SetUIDirty
        ' Do nothing
    End Sub

    Public Function ShowComponentEditor(ByVal component As Object, ByVal parent As System.Windows.Forms.IWin32Window) As Boolean Implements IUIService.ShowComponentEditor
        Return False
    End Function

    Public Function ShowDialog(ByVal form As System.Windows.Forms.Form) As System.Windows.Forms.DialogResult Implements IUIService.ShowDialog
        Return form.ShowDialog(_mainForm)
    End Function

    Public Sub ShowError(ByVal ex As System.Exception, ByVal message As String) Implements IUIService.ShowError
        MessageBox.Show(_mainForm, "Piped error: " + message + Environment.NewLine + Environment.NewLine + ex.ToString())
    End Sub

    Public Sub ShowError(ByVal ex As System.Exception) Implements IUIService.ShowError
        MessageBox.Show(_mainForm, "Piped error: " + ex.ToString())
    End Sub

    Public Sub ShowError(ByVal message As String) Implements IUIService.ShowError
        MessageBox.Show(_mainForm, "Piped error: " + message)
    End Sub

    Public Function ShowMessage(ByVal message As String, ByVal caption As String, ByVal buttons As System.Windows.Forms.MessageBoxButtons) As System.Windows.Forms.DialogResult Implements IUIService.ShowMessage
        Return MessageBox.Show(_mainForm, message, caption, buttons, MessageBoxIcon.Information)
    End Function

    Public Sub ShowMessage(ByVal message As String, ByVal caption As String) Implements IUIService.ShowMessage
        MessageBox.Show(_mainForm, message, caption)
    End Sub

    Public Sub ShowMessage(ByVal message As String) Implements IUIService.ShowMessage
        MessageBox.Show(_mainForm, message)
    End Sub

    Public Function ShowToolWindow(ByVal toolWindow As System.Guid) As Boolean Implements IUIService.ShowToolWindow
        Return False
    End Function

    Public ReadOnly Property Styles() As System.Collections.IDictionary Implements IUIService.Styles
        Get
            Return _styles
        End Get
    End Property
End Class

