Option Explicit On
Option Strict Off

'==============================================================================
' Basiert auf der Arbeit von Tim Dawson, www.divil.co.uk
'==============================================================================
Imports System
Imports System.Windows.Forms
Imports System.Drawing.Design
Imports System.ComponentModel.Design


Friend Class ToolboxService
    Inherits ListBox
    Implements IToolboxService

    Friend designPanel As Control = Nothing
    Private lastSelectedIndex As Long = -1
    Private _Host As IDesignerHost
    Private _ToolboxService As IToolboxService


    Public Sub New()
        MyBase.New()

    End Sub

    Public Sub LoadDefaultItems(ByVal mSteuerelemente As Designer.Controls)

        'alle vorhandenene eintrge lschen
        MyClass.Items.Clear()
        MyClass.Sorted = False

        'prfen ob Steuerelemente hinzugefgt werden sollen
        If mSteuerelemente.Button = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.Button)))
        End If
        If mSteuerelemente.CheckBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.CheckBox)))
        End If
        If mSteuerelemente.CheckedListBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.CheckedListBox)))
        End If
        If mSteuerelemente.ComboBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ComboBox)))
        End If
        If mSteuerelemente.DateTimePicker = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.DateTimePicker)))
        End If
        If mSteuerelemente.Label = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.Label)))
        End If
        If mSteuerelemente.LinkLabel = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.LinkLabel)))
        End If
        If mSteuerelemente.ListBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ListBox)))
        End If
        If mSteuerelemente.ListView = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ListView)))
        End If
        If mSteuerelemente.MaskedTextBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.MaskedTextBox)))
        End If
        If mSteuerelemente.MonthCalendar = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.MonthCalendar)))
        End If
        If mSteuerelemente.NotifyIcon = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.NotifyIcon)))
        End If
        If mSteuerelemente.PictureBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.PictureBox)))
        End If
        If mSteuerelemente.ProgressBar = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ProgressBar)))
        End If
        If mSteuerelemente.RadioButton = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.RadioButton)))
        End If
        If mSteuerelemente.RichTextBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.RichTextBox)))
        End If
        If mSteuerelemente.TextBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.TextBox)))
        End If
        If mSteuerelemente.ToolTip = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ToolTip)))
        End If
        If mSteuerelemente.TreeView = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.TreeView)))
        End If
        If mSteuerelemente.WebBrowser = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.WebBrowser)))
        End If
        If mSteuerelemente.GroupBox = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.GroupBox)))
        End If
        If mSteuerelemente.Panel = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.Panel)))
        End If

        'MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.SplitContainer)))

        If mSteuerelemente.TabControl = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.TabControl)))
        End If
        If mSteuerelemente.TableLayoutPanel = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.TableLayoutPanel)))
        End If
        If mSteuerelemente.ContextMenuStrip = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ContextMenuStrip)))
        End If

        'MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.MenuStrip)))
        'MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.StatusStrip)))
        'MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ToolStrip)))
        'MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ToolStripContainer)))

        If mSteuerelemente.DataGridView = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.DataGridView)))
        End If
        If mSteuerelemente.ImageList = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ImageList)))
        End If
        If mSteuerelemente.Timer = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.Timer)))
        End If
        If mSteuerelemente.ColorDialog = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.ColorDialog)))
        End If
        If mSteuerelemente.FolderBrowserDialog = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.FolderBrowserDialog)))
        End If
        If mSteuerelemente.FontDialog = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.FontDialog)))
        End If
        If mSteuerelemente.OpenFileDialog = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.OpenFileDialog)))
        End If
        If mSteuerelemente.SaveFileDialog = True Then
            MyClass.Items.Add(New ToolboxItem(GetType(System.Windows.Forms.SaveFileDialog)))
        End If

    End Sub

    Public Property Host() As IDesignerHost
        Get
            Return _Host
        End Get
        Set(ByVal value As IDesignerHost)
            _Host = value
        End Set
    End Property

    Public Property ToolboxService() As IToolboxService
        Get
            Return _ToolboxService
        End Get
        Set(ByVal value As IToolboxService)
            _ToolboxService = value
        End Set
    End Property

    Public Sub AddCreator(ByVal creator As System.Drawing.Design.ToolboxItemCreatorCallback, ByVal format As String, ByVal host As System.ComponentModel.Design.IDesignerHost) Implements IToolboxService.AddCreator
        ' No implementation
    End Sub

    Public Sub AddCreator(ByVal creator As System.Drawing.Design.ToolboxItemCreatorCallback, ByVal format As String) Implements IToolboxService.AddCreator
        ' No implementation
    End Sub

    Public Sub AddLinkedToolboxItem(ByVal toolboxItem As System.Drawing.Design.ToolboxItem, ByVal category As String, ByVal host As System.ComponentModel.Design.IDesignerHost) Implements IToolboxService.AddLinkedToolboxItem
        ' No implementation
    End Sub

    Public Sub AddLinkedToolboxItem(ByVal toolboxItem As System.Drawing.Design.ToolboxItem, ByVal host As System.ComponentModel.Design.IDesignerHost) Implements IToolboxService.AddLinkedToolboxItem
        ' No implementation
    End Sub

    Public Sub AddToolboxItem(ByVal toolboxItem As System.Drawing.Design.ToolboxItem, ByVal category As String) Implements IToolboxService.AddToolboxItem
        AddToolboxItem(toolboxItem)
    End Sub

    Public Sub AddToolboxItem(ByVal toolboxItem As System.Drawing.Design.ToolboxItem) Implements IToolboxService.AddToolboxItem
        Items.Add(toolboxItem)
    End Sub

    Public Function SerializeToolboxItem(ByVal toolboxItem As System.Drawing.Design.ToolboxItem) As Object Implements IToolboxService.SerializeToolboxItem
        Return New Windows.Forms.DataObject(toolboxItem)
    End Function

    Public Function DeSerializeToolboxItem(ByVal serializedObject As Object) As System.Drawing.Design.ToolboxItem Implements IToolboxService.DeserializeToolboxItem
        Return MyClass.DeSerializeToolboxItem(serializedObject, MyClass.Host)
    End Function

    Public Function DeSerializeToolboxItem(ByVal serializedObject As Object, ByVal host As System.ComponentModel.Design.IDesignerHost) As System.Drawing.Design.ToolboxItem Implements IToolboxService.DeserializeToolboxItem
        Return CType(serializedObject, Windows.Forms.DataObject).GetData("myFormat")
    End Function

    Public Function GetSelectedToolboxItem(ByVal host As System.ComponentModel.Design.IDesignerHost) As System.Drawing.Design.ToolboxItem Implements IToolboxService.GetSelectedToolboxItem
        Return GetSelectedToolboxItem()
    End Function

    Public Function GetSelectedToolboxItem() As System.Drawing.Design.ToolboxItem Implements IToolboxService.GetSelectedToolboxItem
        If (MyClass.SelectedIndex = -1) Then
            Return Nothing
        Else
            Return CType(MyClass.SelectedItem, ToolboxItem)
        End If
    End Function

    Public Function GetToolboxItems(ByVal category As String, ByVal host As System.ComponentModel.Design.IDesignerHost) As System.Drawing.Design.ToolboxItemCollection Implements IToolboxService.GetToolboxItems
        Return GetToolboxItems()
    End Function

    Public Function GetToolboxItems(ByVal category As String) As System.Drawing.Design.ToolboxItemCollection Implements IToolboxService.GetToolboxItems
        Return GetToolboxItems()
    End Function

    Public Function GetToolboxItems(ByVal host As System.ComponentModel.Design.IDesignerHost) As System.Drawing.Design.ToolboxItemCollection Implements IToolboxService.GetToolboxItems
        Return GetToolboxItems()
    End Function

    Public Function GetToolboxItems() As System.Drawing.Design.ToolboxItemCollection Implements IToolboxService.GetToolboxItems
        Dim t() As ToolboxItem
        ReDim t(Items.Count)
        Items.CopyTo(t, 0)

        Return New ToolboxItemCollection(t)
    End Function

    Public Function IsSupported(ByVal serializedObject As Object, ByVal filterAttributes As System.Collections.ICollection) As Boolean Implements IToolboxService.IsSupported
        Return False
    End Function

    Public Function IsSupported(ByVal serializedObject As Object, ByVal host As System.ComponentModel.Design.IDesignerHost) As Boolean Implements IToolboxService.IsSupported
        Return False
    End Function

    Public Function IsToolboxItem(ByVal serializedObject As Object, ByVal host As System.ComponentModel.Design.IDesignerHost) As Boolean Implements IToolboxService.IsToolboxItem
        Return False
    End Function

    Public Function IsToolboxItem(ByVal serializedObject As Object) As Boolean Implements IToolboxService.IsToolboxItem
        Return False
    End Function

    Public Sub RemoveCreator(ByVal format As String, ByVal host As System.ComponentModel.Design.IDesignerHost) Implements IToolboxService.RemoveCreator
        ' No implementation
    End Sub

    Public Sub RemoveCreator(ByVal format As String) Implements IToolboxService.RemoveCreator
        ' No implementation
    End Sub

    Public Sub RemoveToolboxItem(ByVal toolboxItem As System.Drawing.Design.ToolboxItem, ByVal category As String) Implements IToolboxService.RemoveToolboxItem
        RemoveToolboxItem(toolboxItem)
    End Sub

    Public Sub RemoveToolboxItem(ByVal toolboxItem As System.Drawing.Design.ToolboxItem) Implements IToolboxService.RemoveToolboxItem
        Items.Remove(toolboxItem)
    End Sub

    Public Sub SelectedToolboxItemUsed() Implements IToolboxService.SelectedToolboxItemUsed
        MyBase.SelectedIndex = -1
    End Sub

    Public Function SetCursor() As Boolean Implements IToolboxService.SetCursor
        If MyClass.SelectedIndex = -1 Then
            designPanel.Cursor = Cursors.Default
        Else
            designPanel.Cursor = Cursors.Cross
        End If

        Return True
    End Function

    Public Sub SetSelectedToolboxItem(ByVal toolboxItem As System.Drawing.Design.ToolboxItem) Implements IToolboxService.SetSelectedToolboxItem
        MyBase.SelectedItem = toolboxItem
    End Sub

    Public ReadOnly Property CategoryNames() As System.Drawing.Design.CategoryNameCollection Implements IToolboxService.CategoryNames
        Get
            Return Nothing
        End Get
    End Property

    Public Property SelectedCategory() As String Implements IToolboxService.SelectedCategory
        Get
            Return Nothing
        End Get
        Set(ByVal Value As String)
            'Do nothing?
        End Set
    End Property

    Private Function ShouldSerializeItems() As Boolean
        Return False
    End Function

    Public Overrides Sub Refresh() Implements IToolboxService.Refresh
        MyClass.Refresh()
    End Sub

    Private Sub ToolboxService_DrawItem(ByVal sender As Object, ByVal e As System.Windows.Forms.DrawItemEventArgs) Handles Me.DrawItem
        Dim mTbI As ToolboxItem
        Dim mBitmapBounds As Rectangle
        Dim mStringBounds As Rectangle

        If sender.SelectedIndex = e.Index Then
            e.Graphics.FillRectangle(Brushes.LightSteelBlue, e.Bounds)
        Else
            e.Graphics.FillRectangle(Brushes.Gainsboro, e.Bounds)
        End If
        mTbI = CType(sender.Items(e.Index), ToolboxItem)
        mBitmapBounds = New Rectangle(e.Bounds.Location.X, e.Bounds.Location.Y, mTbI.Bitmap.Width, e.Bounds.Height)
        mStringBounds = New Rectangle(e.Bounds.Location.X + mBitmapBounds.Width + 10, e.Bounds.Location.Y, e.Bounds.Width - mBitmapBounds.Width, e.Bounds.Height + 10)
        e.Graphics.DrawImage(mTbI.Bitmap, mBitmapBounds)
        e.Graphics.DrawString(mTbI.DisplayName, sender.Font, Brushes.Black, mStringBounds)

    End Sub

    Private Sub ToolboxService_MeasureItem(ByVal sender As Object, ByVal e As System.Windows.Forms.MeasureItemEventArgs) Handles Me.MeasureItem
        Dim mTbI As ToolboxItem
        Dim mTextSize As Size

        If MyClass.SelectedIndex < 0 Then Exit Sub
        mTbI = MyClass.Items(e.Index)
        mTextSize = e.Graphics.MeasureString(mTbI.DisplayName, sender.Font).ToSize()
        e.ItemWidth = mTbI.Bitmap.Width + mTextSize.Width
        If (mTbI.Bitmap.Height > mTextSize.Height) Then
            e.ItemHeight = mTbI.Bitmap.Height
        Else
            e.ItemHeight = mTextSize.Height
        End If
    End Sub

    Private Sub ToolboxService_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Me.MouseDown
        Dim lastSelectedBounds As Rectangle
        Dim mTbI As ToolboxItem
        Dim mTbS As IToolboxService
        Dim mTbU As IToolboxUser
        Dim mD As Windows.Forms.DataObject

        'neue Auswahl
        sender.SelectedIndex = sender.IndexFromPoint(e.X, e.Y)
        'prfen ob bereits eine Auswahl getroffen wurde
        If lastSelectedIndex <> -1 Then
            'Rechteck letzte Auswahl
            lastSelectedBounds = MyClass.GetItemRectangle(lastSelectedIndex)
            'Highlight von letzter Auswahl lschen
            sender.Invalidate(lastSelectedBounds)
            'neue Auswahl Highlight
            sender.Invalidate(sender.GetItemRectangle(sender.SelectedIndex))
        End If
        If sender.SelectedIndex <> 0 Then
            'Doppelclick - Positionierung auf Standardposition mit Standardwerten
            If e.Clicks = 2 Then
                mTbU = Host.GetDesigner(Host.RootComponent)
                If (mTbU Is Nothing) = False Then
                    mTbU.ToolPicked(sender.Items(MyClass.SelectedIndex))
                End If

                'Drap&Drop
            ElseIf e.Clicks < 2 Then
                mTbI = sender.Items(MyClass.SelectedIndex)
                mTbS = _ToolboxService

                'The IToolboxService serializes ToolboxItems by packaging them in Objects.
                mD = mTbS.SerializeToolboxItem(mTbI)

                Try
                    sender.DoDragDrop(mD, DragDropEffects.Copy)
                Catch ex As Exception
                    MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
                End Try
            End If
        End If

        'prfen ob neue Auswahl
        If lastSelectedIndex <> sender.SelectedIndex Then
            lastSelectedIndex = sender.SelectedIndex
        End If
    End Sub

    Private Sub ToolboxService_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.SelectedIndexChanged
        Dim lastSelectedBounds As Rectangle

        'prfen ob bereits eine Auswahl getroffen wurde
        If lastSelectedIndex <> -1 Then
            'Rechteck letzte Auswahl
            lastSelectedBounds = MyClass.GetItemRectangle(lastSelectedIndex)
            ' Highlight von letzter Auswahl lschen
            MyClass.Invalidate(lastSelectedBounds)
        Else
            'SelectPointer()
        End If
        'prfen ob neue Auswahl
        If lastSelectedIndex <> sender.SelectedIndex Then
            lastSelectedIndex = sender.SelectedIndex
        End If

    End Sub

End Class
'End Namespace
