'==============================================================================
' Basiert auf der Arbeit von Tim Dawson, www.divil.co.uk
'==============================================================================
Imports System
Imports System.ComponentModel.Design.Serialization

Friend Class NameCreationService
    Implements INameCreationService

    Public Function CreateName(ByVal container As System.ComponentModel.IContainer, ByVal dataType As System.Type) As String Implements INameCreationService.CreateName
        Dim i As Integer = 0
        Dim name As String = dataType.Name

        ' Increment counter until we find a name that's not in use
        While (True)
            i += 1
            If (container.Components(name & i.ToString()) Is Nothing) Then
                Exit While
            End If
        End While

        Return name & i.ToString()
    End Function

    Public Sub ValidateName(ByVal name As String) Implements INameCreationService.ValidateName
        ' Use our existing method to check but then throw an exception if it's invalid
        If Not (IsValidName(name)) Then
            Throw New ArgumentException("Invalid name: " + name)
        End If
    End Sub

    Public Function IsValidName(ByVal name As String) As Boolean Implements INameCreationService.IsValidName
        ' Check that we were actually passed a name, with a length
        If (name Is Nothing Or name.Length = 0) Then
            Return False
        End If

        ' First character must be a letter
        If (Not Char.IsLetter(name, 0)) Then
            Return False
        End If

        ' Don't allow a leading underscore
        If (name.StartsWith("_")) Then
            Return False
        End If

        ' Make sure there's nothing in the proposed name that isn't a letter or digit
        Dim i As Integer
        For i = 0 To name.Length - 1
            If (Not Char.IsLetterOrDigit(name, i)) Then
                Return False
            End If
        Next

        Return True
    End Function

    Public Sub New()

    End Sub
End Class

