'==============================================================================
' Basiert auf der Arbeit von Tim Dawson, www.divil.co.uk
'==============================================================================
Imports System
Imports System.ComponentModel.Design
Imports System.Collections

Friend Class MenuCommandService
    Implements IMenuCommandService

    Private menuCommands As ArrayList = Nothing

    Public Sub New()
        menuCommands = New ArrayList()
    End Sub

    Public Sub AddCommand(ByVal command As System.ComponentModel.Design.MenuCommand) Implements IMenuCommandService.AddCommand
        menuCommands.Add(command)
    End Sub

    Public Sub AddVerb(ByVal verb As System.ComponentModel.Design.DesignerVerb) Implements IMenuCommandService.AddVerb
        ' No implementation
    End Sub

    Public Function FindCommand(ByVal commandID As System.ComponentModel.Design.CommandID) As System.ComponentModel.Design.MenuCommand Implements IMenuCommandService.FindCommand
        Return Nothing
    End Function

    Public Function GlobalInvoke(ByVal commandID As System.ComponentModel.Design.CommandID) As Boolean Implements IMenuCommandService.GlobalInvoke
        Dim command As MenuCommand
        For Each command In menuCommands
            If command.CommandID.ToString = commandID.ToString Then
                command.Invoke()
                Exit For
            End If
        Next

        Return False
    End Function

    Public Sub RemoveCommand(ByVal command As System.ComponentModel.Design.MenuCommand) Implements IMenuCommandService.RemoveCommand
        menuCommands.Remove(command)
    End Sub

    Public Sub RemoveVerb(ByVal verb As System.ComponentModel.Design.DesignerVerb) Implements IMenuCommandService.RemoveVerb
        ' No implementation
    End Sub

    Public Sub ShowContextMenu(ByVal menuID As System.ComponentModel.Design.CommandID, ByVal x As Integer, ByVal y As Integer) Implements IMenuCommandService.ShowContextMenu
        ' No implementation
    End Sub

    Public ReadOnly Property Verbs() As System.ComponentModel.Design.DesignerVerbCollection Implements IMenuCommandService.Verbs
        Get
            Return New DesignerVerbCollection()
        End Get
    End Property
End Class

