Imports System
Imports System.Resources
Imports System.IO
Imports System.ComponentModel.Design

''' Empty implementation of a ResourceService. Here is where you can control the way in which
''' resources are read and written. This sample doesn't play with them though.
Friend Class ResourceService
    Implements IResourceService
    Private reader As ResourceReader
    Private writer As ResourceWriter
    Private host As IDesignerHost
    Private ms As MemoryStream

    Public Sub New(ByVal host As IDesignerHost)
        Me.host = host
    End Sub

#Region "Implementation of IResourceService"

    Public Function GetResourceReader(ByVal info As System.Globalization.CultureInfo) As System.Resources.IResourceReader Implements IResourceService.GetResourceReader
        If reader Is Nothing Then
            If ms Is Nothing Then
                ms = New MemoryStream()
            End If
            reader = New ResourceReader(ms)
        End If
        Return reader
    End Function

    Public Function GetResourceWriter(ByVal info As System.Globalization.CultureInfo) As System.Resources.IResourceWriter Implements IResourceService.GetResourceWriter
        If writer Is Nothing Then
            If ms Is Nothing Then
                ms = New MemoryStream()
            End If
            writer = New ResourceWriter(ms)
        End If
        Return writer
    End Function

#End Region
End Class


