Imports System
Imports System.ComponentModel


Friend Class PropertyGridSite
    Implements ISite
    Private sp As IServiceProvider
    Private m_component As IComponent

    Public Sub New(ByVal sp As IServiceProvider, ByVal component As IComponent)
        sp = sp
        m_component = component
    End Sub

#Region " ISite and IServiceProvider Implementations "

    Public ReadOnly Property Component() As System.ComponentModel.IComponent Implements ISite.Component
        Get
            Return m_component
        End Get
    End Property

    Public ReadOnly Property Container() As System.ComponentModel.IContainer Implements ISite.Container
        Get
            Return Nothing
        End Get
    End Property

    Public ReadOnly Property DesignMode() As Boolean Implements ISite.DesignMode
        Get
            Return False
        End Get
    End Property

    Public Property Name() As String Implements ISite.Name
        Get
            Return Nothing
        End Get
        Set(ByVal value As String)
        End Set
    End Property

    Public Function GetService(ByVal serviceType As Type) As Object Implements IServiceProvider.GetService
        If sp IsNot Nothing Then
            Return sp.GetService(serviceType)
        End If
        Return Nothing
    End Function

#End Region

End Class

