'==============================================================================
' Basiert auf der Arbeit von Tim Dawson, www.divil.co.uk
'==============================================================================
Imports System
Imports System.ComponentModel.Design


Friend Class MegaDesignerTransaction
    Inherits DesignerTransaction

    Private _host As DesignerHost = Nothing

    Protected Overrides Sub OnCommit()
        ' Fire the transaction events on the designer host
        _host.OnTransactionClosing(True)
        _host.OnTransactionClosed(True)
    End Sub

    Protected Overrides Sub OnCancel()
        ' Fire the transaction events on the designer host
        _host.OnTransactionClosing(False)
        _host.OnTransactionClosed(False)
    End Sub

    Public Sub New(ByVal host As DesignerHost, ByVal description As String)
        ' Record a reference to the designer host, as we need this in order to tell it the transaction has been completed
        _host = host
    End Sub

    Public Sub New(ByVal host As DesignerHost)
        ' Record a reference to the designer host, as we need this in order to tell it the transaction has been completed
        _host = host
    End Sub
End Class
