'==============================================================================
' Basiert auf der Arbeit von Tim Dawson, www.divil.co.uk
'==============================================================================
Imports System
Imports System.ComponentModel
Imports System.ComponentModel.Design
Imports System.ComponentModel.Design.Serialization
Imports System.Collections

Friend Class DesignSite
    Implements ISite
    Implements IServiceProvider
    Implements IDictionaryService

    ' Container
    Private _host As IDesignerHost = Nothing
    Private _component As IComponent = Nothing
    Private _dictionary As Hashtable = Nothing
    Private _name As String = ""

    Public Sub New(ByVal newhost As IDesignerHost, ByVal newname As String)
        _host = newhost
        _name = newname
    End Sub

#Region " ISite and IServiceProvider Implementations "

    Public ReadOnly Property Component() As System.ComponentModel.IComponent Implements ISite.Component
        Get
            Return _component
        End Get
    End Property

    Public ReadOnly Property Container() As System.ComponentModel.IContainer Implements ISite.Container
        Get
            Return _host.Container
        End Get
    End Property

    Public ReadOnly Property DesignMode() As Boolean Implements ISite.DesignMode
        Get
            Return True
        End Get
    End Property

    Public Property Name() As String Implements ISite.Name
        Get
            Return _name
        End Get
        Set(ByVal Value As String)
            Dim oldName As String

            ' Check if we're trying to set a null name
            If Value Is Nothing Then
                ' ArgumentException("Cannot set a component's name to a null value.")
            End If

            ' Check we're not trying to set the same name as we've already got
            If Value = _name Then
                Return
            End If

            ' Make sure there isn't already a component with this name in the container
            If CType(_host, DesignerHost).ContainsName(Value) Then
                Throw New ArgumentException("Eine Komponente mit diesem Namen existiert bereits im Container.") '"There is already a component with this name in the container."
            End If

            ' Remember the old name
            oldName = _name

            ' Apply new name
            Dim attr As Attribute()
            Dim md As MemberDescriptor = TypeDescriptor.CreateProperty(CType(_component, Object).GetType(), "Name", GetType(String), attr)
            CType(_host, DesignerHost).OnComponentChanging(Component, md)
            _name = Value
            CType(_host, DesignerHost).OnComponentRename(Component, oldName, _name)
            'CType(_host, DesignerHost).OnComponentChanged(Component, md, oldName, _name)
        End Set
    End Property

    Public Function GetService(ByVal serviceType As System.Type) As Object Implements IServiceProvider.GetService
        If serviceType.Equals(GetType(IDictionaryService)) Then
            Return Me
        Else
            Return _host.GetService(serviceType)
        End If
    End Function
#End Region

    Friend Sub SetComponent(ByVal newcomponent As IComponent)
        _component = newcomponent
        If _name = "" Then
            Dim nameService As INameCreationService = CType(GetService(GetType(INameCreationService)), INameCreationService)
            _name = nameService.CreateName(_host.Container, CType(newcomponent, Object).GetType())
        End If
    End Sub

#Region " IDictionaryService Implementation "

    Public Function GetKey(ByVal value As Object) As Object Implements IDictionaryService.GetKey
        If (_dictionary Is Nothing) Then
            Return Nothing
        Else
            Return GetKeyFromValue(value)
        End If
    End Function

    Private Function GetKeyFromValue(ByVal value As Object) As Object
        Dim e As IDictionaryEnumerator = _dictionary.GetEnumerator()

        While e.MoveNext()
            If e.Value Is value Then
                Return e.Key
            End If
        End While

        Return Nothing
    End Function

    Public Function GetValue(ByVal key As Object) As Object Implements IDictionaryService.GetValue
        If (_dictionary Is Nothing) Then
            Return Nothing
        Else
            Return _dictionary(key)
        End If
    End Function

    Public Sub SetValue(ByVal key As Object, ByVal value As Object) Implements IDictionaryService.SetValue
        If _dictionary Is Nothing Then
            _dictionary = New Hashtable()
        End If

        ' Remove if we're setting to null
        If value Is Nothing Then
            _dictionary.Remove(key)
            Return
        End If

        ' Set value
        _dictionary(key) = value
    End Sub
#End Region

End Class

